/*###########################################################*/
/*#                                                         #*/
/*# File:           CDev.c                                  #*/
/*# Version:        3.0                                     #*/
/*# Author:                                                 #*/
/*# Copyright:      (c) 1989 by Apple Computer, Inc.        #*/
/*# Developer Technical Support Apple II Sample Code        #*/
/*#                                                         #*/
/*# Description:    This file contains the cdev C           #*/
/*#                 routine used by the Shell CDEV.         #*/
/*#                                                         #*/
/*#---------------------------------------------------------#*/
/*#                                                         #*/
/*# Development History:                                    #*/
/*#                                                         #*/
/*# Who     Date        The Modification                    #*/
/*# ---     --------    ----------------                    #*/
/*#                                                         #*/
/*###########################################################*/

#include <Types.h>
#include <GSOS.h>
#include <Quickdraw.h>
#include <Font.h>
#include <Memory.h>
#include <IntMath.h>
#include <Event.h>
#include <ProDOS.h>
#include <Locator.h>
#include <Control.h>
#include <Window.h>
#include <List.h>
#include <Scrap.h>
#include <Dialog.h>
#include <Menu.h>
#include <Desk.h>
#include <StdFile.h>
#include <QDAUX.h>
#include <Print.h>
#include <MiscTool.h>
#include <LineEdit.h>
#include <Resources.h>

#include "CDEV.h"

/*###########################################################*/
/*#     Actual CDEV, this is called by the control panel    #*/
/*###########################################################*/

#define AboutID     0x1000

#define PopUpList   0x5000
#define PopUp1      0x5001
#define PopUp2      0x5002
#define PopUp3      0x5003
#define PopUp1Item1 0x5101
#define PopUp1Item2 0x5102
#define PopUp1Item3 0x5103
#define PopUp1Item4 0x5104
#define PopUp2Item1 0x5201
#define PopUp2Item2 0x5202
#define PopUp2Item3 0x5203
#define PopUp3Item1 0x5301
#define PopUp3Item2 0x5302


int         _toolErr;       /* normally, this is defined in Start.obj */

/* This routine is eventually linked and then placed into a cdev code resource.
  The only requirements are that this routine is at the beginning of the resource
  so if the CDEV has any other routines they must follow this one.  The cdev's resource
  fork is always opened when a call to the cdev is made.  The cdev can also assume
  that the current port is set to the ctl panel window except in the boot message,
  where quickdraw isn't even started, and in the about message, where it is the port
  of the help window.  All normal managers will be stared up for all calls except
  the boot call, which will only have miscTools & Resource Manager started. */

pascal long CDEV(message,data1, data2)
int     message;
long    data1;
long    data2;
{
    int         retCode;
    CtlRecHndl  tempCtl;
    
    retCode = 0;    /* initialize the function result to zero, so that we will work in
                        future versions of the Control Panel! */

    switch(message) {
        case BootCDEV:
            /* If the wantBoot flag is set, this routine will be called during the
              startup sequence.  The control panel takes care of drawing the "boot"
              icon.  When this call is made, the machine state is bad at best.
              QuickDraw is not even started up.  The parameters to this call are
              undefined. */
            break;

        case MachineCDEV:
            /* This is called if the wantMachine bit is set in the CDEV flags.
              It enables the CDEV to do further checking to see if it makes
              sense for the CDEV to be visible to the user or not.  For instance,
              if the CDEV controls a setting for some hardware, we could check to
              see if the hardware is really connected.  The parameters are undefined
              for this call and the result is passed back as the function result.  0 =
              don't show this CDEV, <>0 = show this CDEV.  The control panel will do
              some machine checking even before calling this routine by checking the
              ROM version number against the machine field of the cdev flags resource */
            break;

        case CreateCDEV:
            /* If the wantCreate bit is set, this message is called with the control
              panel's window ptr passed in data1.  The cdev must create any controls
              it has during this call.  The CDEV's resource fork is open during this
              call so resource manager calls can be made.  All controls rectangles
              MUST be relative to 0,0.  The control panel handles offsetting controls
              to the proper place in the window.  Initialization of the controls
              needs to be done in the InitCDEV call.  Just create the controls in this
              call. */
            
            tempCtl = NewControl2(data1,9,(long) PopUpList);
            break;

        case InitCDEV:
            /* If the wantInit flag is set, then this message is passed with data1 =
              the control panel's window ptr.  By  this time the CreateCDEV call
              will have been made and thus the controls used by the CDEV created.
              This call enables the CDEV to initialize the controls before they are
              displayed. */
            
            SetCtlValue(PopUp1Item1, GetCtlHandleFromID(data1, (long) PopUp1));
            SetCtlValue(PopUp2Item1, GetCtlHandleFromID(data1, (long) PopUp2));
            SetCtlValue(PopUp3Item1, GetCtlHandleFromID(data1, (long) PopUp3));
            break;

        case AboutCDEV:
            /* If the wantAbout bit is set in the CDEV flags, this call is made when
              the user selects help.  Data1 = window ptr to the help window.  The
              control panel automatically handles the icon, author, and version #
              display.*/
            
            tempCtl = NewControl2(data1,2, (long) AboutID);
            break;

        case RectCDEV:
            /* If a CDEV has a different size data rectangle depending on some state,
              like the printer & modem port cdev's, then you can get a chance to tell the
              control panel this by setting the wantRect bit in the CDEV flags.  In
              this call, data1 is a ptr to the rect and can be directly modified by
              the CDEV. */
            break;

        case EventsCDEV:
            /* If the wantEvents bit is set, the control panel will call this routine
              with data1 = ptr to the event record.  This allows the cdev to intercept
              and even *gasp* change the event record before it is handled by the
              control panel. */
            break;

        case HitCDEV:
            /* If the CDEV wants to know when a control has been "hit", it can set the
              wantHit bit in the CDEV flags.  When called, data1 = Hdl to Ctl Hit &
              data2 = Ctl ID of hit control.  This message allows the CDEV to perform
              actions based on the control that was selected by the user.*/

            switch((int) data2) {
                case PopUp1:    break;  /*popup1*/
                case PopUp2:    break;  /*popup2*/
                case PopUp3:    break;  /*popup3*/
            }
            break;
            
        case RunCDEV:
            /* This message is called if the "wantRun" bit is set in the CDEV flags.  It
              enables CDEVs like time to update the display.  It is called every 60th of
              a second - every time the DARun call is issued to the control panel. -no
              parameters are passed to this routine. */
            break;

        case CloseCDEV:
            /* The CloseCDEV message is passed if the wantClose bit is set in the CDEV
              flags and the control panel is closing or when the user selects another
              CDEV.  During  this call data1 = windowPtr.  In general, CDEVs can do any
              memory disposal and saving of settings during this call.  The disposal
              of the CDEV's controls is handled automatically by the Control Panel. */
            
            break;

        case ShutDownCDEV:
            /* If the wantShutDown bit is set in the CDEV flags resource then
              this routine is called when the user either disables the CDEV or
              *someday* when the machine is being turned off.  It gives the CDEV
              a chance to turn itself off (or any hardware or software it controls).
              The parameters are undefined in this call. */
            break;
    }   /* end of switch */
    return(retCode);
}   /* end of CDEV function */
